import {
  CosmosDatasourceKind,
  CosmosHandlerKind,
  CosmosProject,
} from "@subql/types-cosmos";

import * as dotenv from 'dotenv';
import path from 'path';

import {chaintypes} from "./src/chaintypes";

const mode = process.env.NODE_ENV || 'production';

// Load the appropriate .env file
const dotenvPath = path.resolve(__dirname, `.env${mode !== 'production' ? `.${mode}` : ''}`);
dotenv.config({ path: dotenvPath });

// Can expand the Datasource processor types via the genreic param
const project: CosmosProject = {
  specVersion: "1.0.0",
  version: "0.0.1",
  name: "cosmoshub-starter",
  description:
    "This project can be use as a starting point for developing your Cosmos CosmosHub based SubQuery project",
  runner: {
    node: {
      name: "@subql/node-cosmos",
      version: ">=3.0.0",
    },
    query: {
      name: "@subql/query",
      version: "*",
    },
  },
  schema: {
    file: "./schema.graphql",
  },
  network: {
    chainId: process.env.CHAIN_ID!,
    endpoint: process.env.ENDPOINT!?.split(',') as string[] | string,
    chaintypes
  },
  dataSources: [
    {
      kind: CosmosDatasourceKind.Runtime,
      startBlock: 26940792,
      mapping: {
        file: "./dist/index.js",
        handlers: [
          {
            handler: "handleBlock",
            kind: CosmosHandlerKind.Block,
          },
          {
            handler: "handleTransaction",
            kind: CosmosHandlerKind.Transaction,
          },
          {
            handler: "handleMessage",
            kind: CosmosHandlerKind.Message,
          },
        ],
      },
    },
  ],
};

// Must set default to the project instance
export default project;
