# Cosmos Indexer DB (Dockerized)

## Files
- `docker-compose.yaml` – base service (Postgres, volume)
- `docker-compose.override.yaml` – mounts `./initdb` and adds healthcheck
- `.env` – versions, credentials, port
- `Makefile` – handy targets
- `initdb/001-extensions-and-params.sql` – extensions and optional ALTER SYSTEM
- `initdb/010-indexer-schema.sql` – **paste the full schema here** (the big SQL you approved)
- `initdb/020-patches.sql` – safe indexes/patches on top
- `initdb/030-util-partitions.sql` – partition helper & seed

## Usage
```bash
cd cosmos-indexer-db

# 1) Paste your FULL schema into initdb/010-indexer-schema.sql
#    (replace the placeholder block).

# 2) Boot the database
make up

# 3) Check logs
make logs

# 4) psql shell
make psql

# 5) Run arbitrary SQL file later
make psql-file FILE=path/to/script.sql
```

> Note: The `initdb/*.sql` scripts run **only on first cluster init**.
> If you change them after the first boot, either recreate the volume
> (`docker compose down -v`) or run the scripts manually with `make psql-file`.
