-- ============================================================================
-- 020-patches.sql — дополнительные индексы/фиксы (всё идемпотентно)
-- ============================================================================

-- TRANSACTIONS: вспомогательные индексы
DO $$
    BEGIN
        IF EXISTS (SELECT 1 FROM information_schema.tables
                   WHERE table_schema='core' AND table_name='transactions') THEN

            -- быстрый доступ к успешным tx в блоке
            CREATE INDEX IF NOT EXISTS idx_txs_success
                ON core.transactions (height DESC, tx_index)
                WHERE code = 0;

            -- сортировка/фильтрация по времени
            CREATE INDEX IF NOT EXISTS idx_txs_time
                ON core.transactions (time DESC);
        END IF;
    END $$;


-- MESSAGES: гарантируем стартовую партицию (если ещё не создана)
DO $$
    BEGIN
        IF EXISTS (SELECT 1 FROM information_schema.tables
                   WHERE table_schema='core' AND table_name='messages') THEN
            CREATE TABLE IF NOT EXISTS core.messages_p0
                PARTITION OF core.messages
                    FOR VALUES FROM (0) TO (1000000);
        END IF;
    END $$;


-- EVENTS: индекс по типу события и индексу сообщения
-- (В таблице core.events НЕТ колонки height — используем только существующие поля)
DO $$
    BEGIN
        IF EXISTS (SELECT 1 FROM information_schema.tables
                   WHERE table_schema='core' AND table_name='events') THEN
            CREATE INDEX IF NOT EXISTS idx_events_type_msg
                ON core.events (event_type, msg_index);
        END IF;
    END $$;


-- EVENT_ATTRS: базовые индексы (в таблице НЕТ height и event_id)
-- В 010 уже создаются:
--   idx_event_attrs_key (key)
--   idx_event_attrs_key_value (key, value)
--   idx_event_attrs_value_trgm (GIN по value)
-- Здесь просто страхуемся, если файл 010 меняли.
DO $$
    BEGIN
        IF EXISTS (SELECT 1 FROM information_schema.tables
                   WHERE table_schema='core' AND table_name='event_attrs') THEN
            CREATE INDEX IF NOT EXISTS idx_event_attrs_key
                ON core.event_attrs (key);
            CREATE INDEX IF NOT EXISTS idx_event_attrs_key_value
                ON core.event_attrs (key, value);
        END IF;
    END $$;