import { Sink, SinkConfig } from "./types.js";
import { StdoutSink } from "./stdout.js";
import { FileSink } from "./file.js";
import { NullSink } from "./null.js";
import { PostgresSink } from "./postgres.js";
import { ClickhouseSink } from "./clickhouse.js";

export function createSink(cfg: SinkConfig): Sink {
    switch (cfg.kind) {
        case "stdout":
            return new StdoutSink(cfg);
        case "file":
            return new FileSink(cfg);
        case "postgres":
            return new PostgresSink({
                kind: "postgres",
                pg: cfg.pg ?? {},
                mode: (cfg as any).pgMode ?? "batch-insert",
                batchSizes: (cfg as any).batchSizes,
            });
        case "clickhouse":
            return new ClickhouseSink(cfg);
        case "null":
            return new NullSink();
        default:
            throw new Error(`Unknown sink kind: ${(cfg as any).kind}`);
    }
}