/* eslint-disable @typescript-eslint/no-explicit-any */
export type SinkKind = "stdout" | "file" | "postgres" | "clickhouse" | "null";

export interface SinkConfig {
    kind: SinkKind;
    // Common options
    flushEvery?: number;   // number of records to buffer before flushing
    // File sink
    outPath?: string;      // path to output file (for kind="file")
    // DB sinks (placeholders for now)
    connectionString?: string;
    table?: string;
    batchSizes?: {
        blocks?: number;
        txs?: number;
        msgs?: number;
        events?: number;
        attrs?: number;
    }
    pg?: {
        connectionString?: string;
        host?: string;
        port?: number;
        user?: string;
        password?: string;
        database?: string;
        ssl?: boolean;
        mode?: "block-atomic" | "batch-insert";
    }
}

export interface Sink {
    /** Initialize resources (streams, connections). */
    init(): Promise<void>;
    /** Write one NDJSON line (already serialized). Must be safe to call concurrently. */
    write(line: string): Promise<void>;
    /** Flush buffered data if any. Optional no-op for some sinks. */
    flush?(): Promise<void>;
    /** Close resources. Should flush and ensure durability. */
    close(): Promise<void>;
}