// Базовые ABCI-типы
export type AbciEventAttr = {
    key: string;
    value: string;
    index?: boolean; // мы будем подставлять true, если отсутствует
};

export type AbciEvent = {
    type: string;
    attributes: AbciEventAttr[];
};

// Результат DeliverTx для одной транзакции из /block_results
export type TxsResult = {
    code: number;
    codespace?: string;
    data?: string;        // base64
    log?: string;         // raw JSON-строка или иной формат
    events?: AbciEvent[]; // tx-level events
    gas_wanted?: string;
    gas_used?: string;
};

// Декодированное сообщение (из Any)
export type DecodedMsgKnown = {
    "@type": string; // type_url
    // далее — поля в snake_case по конкретному proto типу
    [k: string]: unknown;
};
export type DecodedMsgUnknown = {
    "@type": string;      // type_url
    value_b64: string;    // исходные байты Any.value в base64
};
export type DecodedMsg = DecodedMsgKnown | DecodedMsgUnknown;

// Декодированная транзакция (protobuf TxRaw -> Tx)
export type DecodedTx = {
    "@type": "/cosmos.tx.v1beta1.Tx";
    body: {
        messages: DecodedMsg[];
        memo: string;
        timeout_height: string;
        unordered?: boolean;
        timeout_timestamp?: string | null;
        extension_options: unknown[];
        non_critical_extension_options: unknown[];
    };
    auth_info: {
        signer_infos: Array<{
            public_key?:
                | { "@type": "/cosmos.crypto.secp256k1.PubKey"; key: string }
                | { "@type": string; value: string };
            mode_info?: unknown;
            sequence: string;
        }>;
        fee: {
            amount: Array<{ denom: string; amount: string }>;
            gas_limit: string;
            payer: string;
            granter: string;
        };
        tip?: unknown | null;
    };
    signatures: string[]; // base64
};

// Главный объект «блок (RPC-only)»
export type BlockJson = {
    meta: {
        chain_id: string;
        height: string;
        time: string; // ISO-8601
    };
    block: {
        block_id: unknown;
        header: unknown;
        data: {
            txs_base64: string[];
            txs_hex?: string[]; // опционально добавим
        };
        last_commit: unknown;
    };
    block_results: {
        begin_block_events: AbciEvent[];
        end_block_events: AbciEvent[];
        txs_results: TxsResult[];
        validator_updates?: unknown[];
        consensus_param_updates?: unknown;
    };
    txs: Array<{
        index: number;
        hash: string; // HEX_UPPER SHA-256(raw)
        raw: { base64: string; hex: string };
        decoded: DecodedTx;
        tx_response: {
            height: string;
            codespace: string;
            code: number;
            data: string; // base64
            raw_log: string; // как есть
            logs?: Array<{ msg_index: number | null; events: AbciEvent[] }>;
            events?: AbciEvent[]; // tx-level
            gas_wanted: string;
            gas_used: string;
            timestamp: string; // из meta.time
        };
    }>;
    validator_set?: {
        proposer_address: string;
        validators: unknown[];
    };
};