/* eslint-disable @typescript-eslint/no-explicit-any */
import { bytesToHex } from "./bytes.js";

/**
 * Безопасный stringify:
 * - BigInt -> string
 * - Uint8Array -> { "@bytes_hex": "..." }
 * - Date -> ISO
 */
export function safeJsonReplacer(_key: string, value: any) {
    if (typeof value === "bigint") return value.toString();
    if (value instanceof Uint8Array) return { "@bytes_hex": bytesToHex(value) };
    if (value instanceof Date) return value.toISOString();
    return value;
}

export function safeJsonStringify(obj: unknown, space = 2): string {
    return JSON.stringify(obj, safeJsonReplacer, space);
}