/* eslint-disable @typescript-eslint/no-explicit-any */
// Light "stripper" for large or redundant fields.
// For now it's effectively a no-op, but you can enable pruning via options.

export type StripOptions = {
    // If true, drop evidence list (can be large on misbehavior).
    dropEvidence?: boolean;
    // If true, drop txs base64 list from the block copy (you still have decoded txs separately).
    dropTxs?: boolean;
};

export function stripLarge<T = any>(obj: T, opts: StripOptions = {}): T {
    if (!obj || typeof obj !== "object") return obj;

    // shallow clone to avoid mutating original
    const out: any = Array.isArray(obj) ? [...(obj as any)] : { ...(obj as any) };

    // Heuristics for Tendermint block response
    if (out?.block?.evidence && opts.dropEvidence) {
        out.block = { ...out.block, evidence: { evidence: [] } };
    }

    if (out?.block?.data?.txs && opts.dropTxs) {
        out.block = {
            ...out.block,
            data: { ...out.block.data, txs: [] }
        };
    }

    return out as T;
}