/* eslint-disable @typescript-eslint/no-explicit-any */
// Human-friendly duration formatting.

export function formatDuration(totalSeconds: number): string {
    if (!isFinite(totalSeconds) || totalSeconds < 0) return "—";
    const s = Math.floor(totalSeconds);
    const days = Math.floor(s / 86400);
    const hours = Math.floor((s % 86400) / 3600);
    const mins = Math.floor((s % 3600) / 60);
    const secs = s % 60;
    const parts: string[] = [];
    if (days) parts.push(`${days}d`);
    if (hours || parts.length) parts.push(`${hours}h`);
    if (mins || parts.length) parts.push(`${mins}m`);
    parts.push(`${secs}s`);
    return parts.join(" ");
}